/*
 * Copyright (C) 2011 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ASM_ARCH_MXC_PMIC_MC34708_EXTERNAL_H__
#define __ASM_ARCH_MXC_PMIC_MC34708_EXTERNAL_H__


enum {
	MC34708_REG_INT_STATUS0 = 0,
	MC34708_REG_INT_MASK0,
	MC34708_REG_INT_SENSE0,
	MC34708_REG_INT_STATUS1,
	MC34708_REG_INT_MASK1,
	MC34708_REG_INT_SENSE1,
	MC34708_REG_POWER_UP_MODE_SENSE,
	MC34708_REG_IDENTIFICATION,
	MC34708_REG_REGULATOR_FAULT_SENSE,
	MC34708_REG_ACC0,
	MC34708_REG_ACC1,
	MC34708_REG_UNUSED0,
	MC34708_REG_UNUSED1,
	MC34708_REG_POWER_CTL0,
	MC34708_REG_POWER_CTL1,
	MC34708_REG_POWER_CTL2,
	MC34708_REG_MEM_A,
	MC34708_REG_MEM_B,
	MC34708_REG_MEM_C,
	MC34708_REG_MEM_D,
	MC34708_REG_RTC_TIME,
	MC34708_REG_RTC_ALARM,
	MC34708_REG_RTC_DAY,
	MC34708_REG_RTC_DAY_ALARM,
	MC34708_REG_SW1AB,
	MC34708_REG_SW2_3,
	MC34708_REG_SW4AB,
	MC34708_REG_SW5,
	MC34708_REG_SW_OP_MODE_1_2,
	MC34708_REG_SW_OP_MODE_3_4_5,
	MC34708_REG_REGULATOR_SETTING0,
	MC34708_REG_SWBST_CTL,
	MC34708_REG_REGULATOR_MODE0,
	MC34708_REG_GPIOLV0_CTL,
	MC34708_REG_GPIOLV1_CTL,
	MC34708_REG_GPIOLV2_CTL,
	MC34708_REG_GPIOLV3_CTL,
	MC34708_REG_USB_TIMING,
	MC34708_REG_USB_BUTTON,
	MC34708_REG_USB_CTL,
	MC34708_REG_USB_DEVICE_TYPE,
	MC34708_REG_UNUSED2,
	MC34708_REG_UNUSED3,
	MC34708_REG_ADC0,
	MC34708_REG_ADC1,
	MC34708_REG_ADC2,
	MC34708_REG_ADC3,
	MC34708_REG_ADC4,
	MC34708_REG_ADC5,
	MC34708_REG_ADC6,
	MC34708_REG_ADC7,
	MC34708_REG_BATTERY_PROFILE,
	MC34708_REG_CHARGER_DEBOUNCE,
	MC34708_REG_CHARGER_SOURCE,
	MC34708_REG_CHARGER_LED_CTL,
	MC34708_REG_PWM_CTL,
	MC34708_REG_UNUSED4,
	MC34708_REG_UNUSED5,
	MC34708_REG_UNUSED6,
	MC34708_REG_UNUSED7,
	MC34708_REG_UNUSED8,
	MC34708_REG_UNUSED9,
	MC34708_REG_UNUSED10,
	MC34708_REG_UNUSED11,
};

enum {
	MC34708_EVENT_ADCDONEI = 0,
	MC34708_EVENT_TSDONEI = 1,
	MC34708_EVENT_TSPENDET = 2,
	MC34708_EVENT_USBDET = 3,
	MC34708_EVENT_AUXDET = 4,
	MC34708_EVENT_USBOVP = 5,
	MC34708_EVENT_AUXOVP = 6,
	MC34708_EVENT_CHRTIMEEXP = 7,
	MC34708_EVENT_BATTOTP = 8,
	MC34708_EVENT_BATTOVP = 9,
	MC34708_EVENT_CHRCMPL = 10,
	MC34708_EVENT_WKVBUSDET = 11,
	MC34708_EVENT_WKAUXDET = 12,
	MC34708_EVENT_LOWBATT = 13,
	MC34708_EVENT_VBUSREGMI = 14,
	MC34708_EVENT_ATTACH = 15,
	MC34708_EVENT_DETACH = 16,
	MC34708_EVENT_KP = 17,
	MC34708_EVENT_LKP = 18,
	MC34708_EVENT_LKR = 19,
	MC34708_EVENT_UKNOWN_ATTA = 20,
	MC34708_EVENT_ADC_CHANGE = 21,
	MC34708_EVENT_STUCK_KEY = 22,
	MC34708_EVENT_STUCK_KEY_RCV = 23,

	MC34708_EVENT_1HZI = 24,
	MC34708_EVENT_TODAI = 25,
	MC34708_EVENT_Unused1 = 26,
	MC34708_EVENT_PWRON1I = 27,
	MC34708_EVENT_PWRON2I = 28,
	MC34708_EVENT_WDIRESETI = 29,
	MC34708_EVENT_SYSRSTI = 30,
	MC34708_EVENT_RTCRSTI = 31,
	MC34708_EVENT_PCI = 32,
	MC34708_EVENT_WARMI = 33,
	MC34708_EVENT_MEMHLDI = 34,
	MC34708_EVENT_Unused2 = 35,
	MC34708_EVENT_THWARNLI = 36,
	MC34708_EVENT_THWARNHI = 37,
	MC34708_EVENT_CLKI = 38,
	MC34708_EVENT_Unused3 = 39,
	MC34708_EVENT_SCPI = 40,
};
#endif
