/*
 * da9052 register declarations.
 *
 * Copyright(c) 2009 Dialog Semiconductor Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __LINUX_MFD_DA9052_REG_H
#define __LINUX_MFD_DA9052_REG_H

#define DA9052_PAGECON0_REG			0
#define DA9052_STATUSA_REG			1
#define DA9052_STATUSB_REG			2
#define DA9052_STATUSC_REG			3
#define DA9052_STATUSD_REG			4
#define DA9052_EVENTA_REG			5
#define DA9052_EVENTB_REG			6
#define DA9052_EVENTC_REG			7
#define DA9052_EVENTD_REG			8
#define DA9052_FAULTLOG_REG			9
#define DA9052_IRQMASKA_REG			10
#define DA9052_IRQMASKB_REG			11
#define DA9052_IRQMASKC_REG			12
#define DA9052_IRQMASKD_REG			13
#define DA9052_CONTROLA_REG			14
#define DA9052_CONTROLB_REG			15
#define DA9052_CONTROLC_REG			16
#define DA9052_CONTROLD_REG			17
#define DA9052_PDDIS_REG			18
#define DA9052_INTERFACE_REG			19
#define DA9052_RESET_REG			20
#define DA9052_GPIO0001_REG			21
#define DA9052_GPIO0203_REG			22
#define DA9052_GPIO0405_REG			23
#define DA9052_GPIO0607_REG			24
#define DA9052_GPIO0809_REG			25
#define DA9052_GPIO1011_REG			26
#define DA9052_GPIO1213_REG			27
#define DA9052_GPIO1415_REG			28
#define DA9052_ID01_REG				29
#define DA9052_ID23_REG				30
#define DA9052_ID45_REG				31
#define DA9052_ID67_REG				32
#define DA9052_ID89_REG				33
#define DA9052_ID1011_REG			34
#define DA9052_ID1213_REG			35
#define DA9052_ID1415_REG			36
#define DA9052_ID1617_REG			37
#define DA9052_ID1819_REG			38
#define DA9052_ID2021_REG			39
#define DA9052_SEQSTATUS_REG			40
#define DA9052_SEQA_REG				41
#define DA9052_SEQB_REG				42
#define DA9052_SEQTIMER_REG			43
#define DA9052_BUCKA_REG			44
#define DA9052_BUCKB_REG			45
#define DA9052_BUCKCORE_REG			46
#define DA9052_BUCKPRO_REG			47
#define DA9052_BUCKMEM_REG			48
#define DA9052_BUCKPERI_REG			49
#define DA9052_LDO1_REG				50
#define DA9052_LDO2_REG				51
#define DA9052_LDO3_REG				52
#define DA9052_LDO4_REG				53
#define DA9052_LDO5_REG				54
#define DA9052_LDO6_REG				55
#define DA9052_LDO7_REG				56
#define DA9052_LDO8_REG				57
#define DA9052_LDO9_REG				58
#define DA9052_LDO10_REG			59
#define DA9052_SUPPLY_REG			60
#define DA9052_PULLDOWN_REG			61
#define DA9052_CHGBUCK_REG			62
#define DA9052_WAITCONT_REG			63
#define DA9052_ISET_REG				64
#define DA9052_BATCHG_REG			65
#define DA9052_CHGCONT_REG			66
#define DA9052_INPUTCONT_REG			67
#define DA9052_CHGTIME_REG			68
#define DA9052_BBATCONT_REG			69
#define DA9052_BOOST_REG			70
#define DA9052_LEDCONT_REG			71
#define DA9052_LEDMIN123_REG			72
#define DA9052_LED1CONF_REG			73
#define DA9052_LED2CONF_REG			74
#define DA9052_LED3CONF_REG			75
#define DA9052_LED1CONT_REG			76
#define DA9052_LED2CONT_REG			77
#define DA9052_LED3CONT_REG			78
#define DA9052_LED4CONT_REG			79
#define DA9052_LED5CONT_REG			80
#define DA9052_ADCMAN_REG			81
#define DA9052_ADCCONT_REG			82
#define DA9052_ADCRESL_REG			83
#define DA9052_ADCRESH_REG			84
#define DA9052_VDDRES_REG			85
#define DA9052_VDDMON_REG			86
#define DA9052_ICHGAV_REG			87
#define DA9052_ICHGTHD_REG			88
#define DA9052_ICHGEND_REG			89
#define DA9052_TBATRES_REG			90
#define DA9052_TBATHIGHP_REG			91
#define DA9052_TBATHIGHIN_REG			92
#define DA9052_TBATLOW_REG			93
#define DA9052_TOFFSET_REG			94
#define DA9052_ADCIN4RES_REG			95
#define DA9052_AUTO4HIGH_REG			96
#define DA9052_AUTO4LOW_REG			97
#define DA9052_ADCIN5RES_REG			98
#define DA9052_AUTO5HIGH_REG			99
#define DA9052_AUTO5LOW_REG			100
#define DA9052_ADCIN6RES_REG			101
#define DA9052_AUTO6HIGH_REG			102
#define DA9052_AUTO6LOW_REG			103
#define DA9052_TJUNCRES_REG			104
#define DA9052_TSICONTA_REG			105
#define DA9052_TSICONTB_REG			106
#define DA9052_TSIXMSB_REG			107
#define DA9052_TSIYMSB_REG			108
#define DA9052_TSILSB_REG			109
#define DA9052_TSIZMSB_REG			110
#define DA9052_COUNTS_REG			111
#define DA9052_COUNTMI_REG			112
#define DA9052_COUNTH_REG			113
#define DA9052_COUNTD_REG			114
#define DA9052_COUNTMO_REG			115
#define DA9052_COUNTY_REG			116
#define DA9052_ALARMMI_REG			117
#define DA9052_ALARMH_REG			118
#define DA9052_ALARMD_REG			119
#define DA9052_ALARMMO_REG			120
#define DA9052_ALARMY_REG			121
#define DA9052_SECONDA_REG			122
#define DA9052_SECONDB_REG			123
#define DA9052_SECONDC_REG			124
#define DA9052_SECONDD_REG			125
#define DA9052_PAGECON128_REG			128
#define DA9052_CHIPID_REG			129
#define DA9052_CONFIGID_REG			130
#define DA9052_OTPCONT_REG			131
#define DA9052_OSCTRIM_REG			132
#define DA9052_GPID0_REG			133
#define DA9052_GPID1_REG			134
#define DA9052_GPID2_REG			135
#define DA9052_GPID3_REG			136
#define DA9052_GPID4_REG			137
#define DA9052_GPID5_REG			138
#define DA9052_GPID6_REG			139
#define DA9052_GPID7_REG			140
#define DA9052_GPID8_REG			141
#define DA9052_GPID9_REG			142

#define DA9052_PAGE0_REG_START			(DA9052_STATUSA_REG)
#define DA9052_PAGE0_REG_END			(DA9052_SECONDD_REG)

#define DA9052_PAGE1_REG_START			(DA9052_CHIPID_REG)
#define DA9052_PAGE1_REG_END			(DA9052_GPID9_REG)

/* PAGE CONFIGURATION */

/* Reg Page Configuration */
#define DA9052_PAGECON0_REGPAGE			(1<<7)

/* PAGE CONFIGURATION 128 REGISTER */
#define DA9052_PAGECON128_REGPAGE		(1<<7)

/* SYSTEM REGISTER */

/* STATUS REGISTER A */
#define DA9052_STATUSA_VDATDET			(1<<7)
#define DA9052_STATUSA_VBUSSEL			(1<<6)
#define DA9052_STATUSA_DCINSEL			(1<<5)
#define DA9052_STATUSA_VBUSDET			(1<<4)
#define DA9052_STATUSA_DCINDET			(1<<3)
#define DA9052_STATUSA_IDGND			(1<<2)
#define DA9052_STATUSA_IDFLOAT			(1<<1)
#define DA9052_STATUSA_NONKEY			(1<<0)


/* STATUS REGISTER B */
#define DA9052_STATUSB_COMPDET			(1<<7)
#define DA9052_STATUSB_SEQUENCING		(1<<6)
#define DA9052_STATUSB_GPFB2			(1<<5)
#define DA9052_STATUSB_CHGTO			(1<<4)
#define DA9052_STATUSB_CHGEND			(1<<3)
#define DA9052_STATUSB_CHGLIM			(1<<2)
#define DA9052_STATUSB_CHGPRE			(1<<1)
#define DA9052_STATUSB_CHGATT			(1<<0)


/* STATUS REGISTER C */
#define DA9052_STATUSC_GPI7			(1<<7)
#define DA9052_STATUSC_GPI6			(1<<6)
#define DA9052_STATUSC_GPI5			(1<<5)
#define DA9052_STATUSC_GPI4			(1<<4)
#define DA9052_STATUSC_GPI3			(1<<3)
#define DA9052_STATUSC_GPI2			(1<<2)
#define DA9052_STATUSC_GPI1			(1<<1)
#define DA9052_STATUSC_GPI0			(1<<0)


/* STATUS REGISTER D */
#define DA9052_STATUSD_GPI15			(1<<7)
#define DA9052_STATUSD_GPI14			(1<<6)
#define DA9052_STATUSD_GPI13			(1<<5)
#define DA9052_STATUSD_GPI12			(1<<4)
#define DA9052_STATUSD_GPI11			(1<<3)
#define DA9052_STATUSD_GPI10			(1<<2)
#define DA9052_STATUSD_GPI9			(1<<1)
#define DA9052_STATUSD_GPI8			(1<<0)


/* EVENT REGISTER A */
#define DA9052_EVENTA_ECOMP1V2			(1<<7)
#define DA9052_EVENTA_ESEQRDY			(1<<6)
#define DA9052_EVENTA_EALRAM			(1<<5)
#define DA9052_EVENTA_EVDDLOW			(1<<4)
#define DA9052_EVENTA_EVBUSREM			(1<<3)
#define DA9052_EVENTA_EDCINREM			(1<<2)
#define DA9052_EVENTA_EVBUSDET			(1<<1)
#define DA9052_EVENTA_EDCINDET			(1<<0)

/* EVENT REGISTER B */
#define DA9052_EVENTB_ETSIREADY			(1<<7)
#define DA9052_EVENTB_EPENDOWN			(1<<6)
#define DA9052_EVENTB_EADCEOM			(1<<5)
#define DA9052_EVENTB_ETBAT			(1<<4)
#define DA9052_EVENTB_ECHGEND			(1<<3)
#define DA9052_EVENTB_EIDGND			(1<<2)
#define DA9052_EVENTB_EIDFLOAT			(1<<1)
#define DA9052_EVENTB_ENONKEY			(1<<0)

/* EVENT REGISTER C */
#define DA9052_EVENTC_EGPI7			(1<<7)
#define DA9052_EVENTC_EGPI6			(1<<6)
#define DA9052_EVENTC_EGPI5			(1<<5)
#define DA9052_EVENTC_EGPI4			(1<<4)
#define DA9052_EVENTC_EGPI3			(1<<3)
#define DA9052_EVENTC_EGPI2			(1<<2)
#define DA9052_EVENTC_EGPI1			(1<<1)
#define DA9052_EVENTC_EGPI0			(1<<0)

/* EVENT REGISTER D */
#define DA9052_EVENTC_EGPI15			(1<<7)
#define DA9052_EVENTC_EGPI14			(1<<6)
#define DA9052_EVENTC_EGPI13			(1<<5)
#define DA9052_EVENTC_EGPI12			(1<<4)
#define DA9052_EVENTC_EGPI11			(1<<3)
#define DA9052_EVENTC_EGPI10			(1<<2)
#define DA9052_EVENTC_EGPI9			(1<<1)
#define DA9052_EVENTC_EGPI8			(1<<0)


/* FAULT LOG REGISTER */
#define DA9052_FAULTLOG_WAITSET			(1<<7)
#define DA9052_FAULTLOG_NSDSET			(1<<6)
#define DA9052_FAULTLOG_KEYSHUT			(1<<5)
#define DA9052_FAULTLOG_TEMPOVER		(1<<3)
#define DA9052_FAULTLOG_VDDSTART		(1<<2)
#define DA9052_FAULTLOG_VDDFAULT		(1<<1)
#define DA9052_FAULTLOG_TWDERROR		(1<<0)

/* IRQ_MASK REGISTER A */
#define DA9052_IRQMASKA_MCOMP1V2		(1<<7)
#define DA9052_IRQMASKA_MSEQRDY			(1<<6)
#define DA9052_IRQMASKA_MALRAM			(1<<5)
#define DA9052_IRQMASKA_MVDDLOW			(1<<4)
#define DA9052_IRQMASKA_MVBUSREM		(1<<3)
#define DA9052_IRQMASKA_MDCINREM		(1<<2)
#define DA9052_IRQMASKA_MVBUSVLD		(1<<1)
#define DA9052_IRQMASKA_MDCINVLD		(1<<0)

/* IRQ_MASK REGISTER B */
#define DA9052_IRQMASKB_MTSIREADY		(1<<7)
#define DA9052_IRQMASKB_MPENDOWN		(1<<6)
#define DA9052_IRQMASKB_MADCEOM			(1<<5)
#define DA9052_IRQMASKB_MTBAT			(1<<4)
#define DA9052_IRQMASKB_MCHGEND			(1<<3)
#define DA9052_IRQMASKB_MIDGND			(1<<2)
#define DA9052_IRQMASKB_MIDFLOAT		(1<<1)
#define DA9052_IRQMASKB_MNONKEY			(1<<0)

/* IRQ_MASK REGISTER C */
#define DA9052_IRQMASKC_MGPI7			(1<<7)
#define DA9052_IRQMASKC_MGPI6			(1<<6)
#define DA9052_IRQMASKC_MGPI5			(1<<5)
#define DA9052_IRQMASKC_MGPI4			(1<<4)
#define DA9052_IRQMASKC_MGPI3			(1<<3)
#define DA9052_IRQMASKC_MGPI2			(1<<2)
#define DA9052_IRQMASKC_MGPI1			(1<<1)
#define DA9052_IRQMASKC_MGPI0			(1<<0)

/* IRQ_MASK REGISTER D */
#define DA9052_IRQMASKD_MGPI15			(1<<7)
#define DA9052_IRQMASKD_MGPI14			(1<<6)
#define DA9052_IRQMASKD_MGPI13			(1<<5)
#define DA9052_IRQMASKD_MGPI12			(1<<4)
#define DA9052_IRQMASKD_MGPI11			(1<<3)
#define DA9052_IRQMASKD_MGPI10			(1<<2)
#define DA9052_IRQMASKD_MGPI9			(1<<1)
#define DA9052_IRQMASKD_MGPI8			(1<<0)

/* CONTROL REGISTER A */
#define DA9052_CONTROLA_GPIV			(1<<7)
#define DA9052_CONTROLA_PMOTYPE			(1<<5)
#define DA9052_CONTROLA_PMOV			(1<<4)
#define DA9052_CONTROLA_PMIV			(1<<3)
#define DA9052_CONTROLA_PMIFV			(1<<3)
#define DA9052_CONTROLA_PWR1EN			(1<<2)
#define DA9052_CONTROLA_PWREN			(1<<1)
#define DA9052_CONTROLA_SYSEN			(1<<0)

/* CONTROL REGISTER B */
#define DA9052_CONTROLB_SHUTDOWN		(1<<7)
#define DA9052_CONTROLB_DEEPSLEEP		(1<<6)
#define DA9052_CONTROLB_WRITEMODE		(1<<5)
#define DA9052_CONTROLB_BBATEN			(1<<4)
#define DA9052_CONTROLB_OTPREADEN		(1<<3)
#define DA9052_CONTROLB_AUTOBOOT		(1<<2)
#define DA9052_CONTROLB_ACTDIODE		(1<<1)
#define DA9052_CONTROLB_BUCKMERGE		(1<<0)

/* CONTROL REGISTER C */
#define DA9052_CONTROLC_BLINKDUR		(1<<7)
#define DA9052_CONTROLC_BLINKFRQ		(3<<5)
#define DA9052_CONTROLC_DEBOUNCING		(7<<2)
#define DA9052_CONTROLC_PMFB2PIN		(1<<1)
#define DA9052_CONTROLC_PMFB1PIN		(1<<0)

/* CONTROL REGISTER D */
#define DA9052_CONTROLD_WATCHDOG		(1<<7)
#define DA9052_CONTROLD_ACCDETEN		(1<<6)
#define DA9052_CONTROLD_GPI1415SD		(1<<5)
#define DA9052_CONTROLD_NONKEYSD		(1<<4)
#define DA9052_CONTROLD_KEEPACTEN		(1<<3)
#define DA9052_CONTROLD_TWDSCALE		(7<<0)

/* POWER DOWN DISABLE REGISTER */
#define DA9052_PDDIS_PMCONTPD			(1<<7)
#define DA9052_PDDIS_OUT32KPD			(1<<6)
#define DA9052_PDDIS_CHGBBATPD			(1<<5)
#define DA9052_PDDIS_CHGPD			(1<<4)
#define DA9052_PDDIS_HS2WIREPD			(1<<3)
#define DA9052_PDDIS_PMIFPD			(1<<2)
#define DA9052_PDDIS_GPADCPD			(1<<1)
#define DA9052_PDDIS_GPIOPD			(1<<0)

/* CONTROL REGISTER D */
#define DA9052_INTERFACE_IFBASEADDR		(7<<5)
#define DA9052_INTERFACE_NCSPOL			(1<<4)
#define DA9052_INTERFACE_RWPOL			(1<<3)
#define DA9052_INTERFACE_CPHA			(1<<2)
#define DA9052_INTERFACE_CPOL			(1<<1)
#define DA9052_INTERFACE_IFTYPE			(1<<0)

/* CONTROL REGISTER D */
#define DA9052_RESET_RESETEVENT			(3<<6)
#define DA9052_RESET_RESETTIMER			(63<<0)

/* GPIO REGISTERS */

/* GPIO control register for PIN 0 and 1 */
#define DA9052_GPIO0001_GPIO1MODE		(1<<7)
#define DA9052_GPIO0001_GPIO1TYPE		(1<<6)
#define DA9052_GPIO0001_GPIO1PIN		(3<<4)
#define DA9052_GPIO0001_GPIO0MODE		(1<<3)
#define DA9052_GPIO0001_GPIO0TYPE		(1<<2)
#define DA9052_GPIO0001_GPIO0PIN		(3<<0)

/* GPIO control register for PIN 2 and 3 */
#define DA9052_GPIO0203_GPIO3MODE		(1<<7)
#define DA9052_GPIO0203_GPIO3TYPE		(1<<6)
#define DA9052_GPIO0203_GPIO3PIN		(3<<4)
#define DA9052_GPIO0203_GPIO2MODE		(1<<3)
#define DA9052_GPIO0203_GPIO2TYPE		(1<<2)
#define DA9052_GPIO0203_GPIO2PIN		(3<<0)

/* GPIO control register for PIN 4 and 5 */
#define DA9052_GPIO0405_GPIO5MODE		(1<<7)
#define DA9052_GPIO0405_GPIO5TYPE		(1<<6)
#define DA9052_GPIO0405_GPIO5PIN		(3<<4)
#define DA9052_GPIO0405_GPIO4MODE		(1<<3)
#define DA9052_GPIO0405_GPIO4TYPE		(1<<2)
#define DA9052_GPIO0405_GPIO4PIN		(3<<0)

/* GPIO control register for PIN 6 and 7 */
#define DA9052_GPIO0607_GPIO7MODE		(1<<7)
#define DA9052_GPIO0607_GPIO7TYPE		(1<<6)
#define DA9052_GPIO0607_GPIO7PIN		(3<<4)
#define DA9052_GPIO0607_GPIO6MODE		(1<<3)
#define DA9052_GPIO0607_GPIO6TYPE		(1<<2)
#define DA9052_GPIO0607_GPIO6PIN		(3<<0)

/* GPIO control register for PIN 8 and 9 */
#define DA9052_GPIO0809_GPIO9MODE		(1<<7)
#define DA9052_GPIO0809_GPIO9TYPE		(1<<6)
#define DA9052_GPIO0809_GPIO9PIN		(3<<4)
#define DA9052_GPIO0809_GPIO8MODE		(1<<3)
#define DA9052_GPIO0809_GPIO8TYPE		(1<<2)
#define DA9052_GPIO0809_GPIO8PIN		(3<<0)

/* GPIO control register for PIN 10 and 11 */
#define DA9052_GPIO1011_GPIO11MODE		(1<<7)
#define DA9052_GPIO1011_GPIO11TYPE		(1<<6)
#define DA9052_GPIO1011_GPIO11PIN		(3<<4)
#define DA9052_GPIO1011_GPIO10MODE		(1<<3)
#define DA9052_GPIO1011_GPIO10TYPE		(1<<2)
#define DA9052_GPIO1011_GPIO10PIN		(3<<0)

/* GPIO control register for PIN 12 and 13 */
#define DA9052_GPIO1213_GPIO13MODE		(1<<7)
#define DA9052_GPIO1213_GPIO13TYPE		(1<<6)
#define DA9052_GPIO1213_GPIO13PIN		(3<<4)
#define DA9052_GPIO1213_GPIO12MODE		(1<<3)
#define DA9052_GPIO1213_GPIO12TYPE		(1<<2)
#define DA9052_GPIO1213_GPIO12PIN		(3<<0)

/* GPIO control register for PIN 14 and 15 */
#define DA9052_GPIO1415_GPIO15MODE		(1<<7)
#define DA9052_GPIO1415_GPIO15TYPE		(1<<6)
#define DA9052_GPIO1415_GPIO15PIN		(3<<4)
#define DA9052_GPIO1415_GPIO14MODE		(1<<3)
#define DA9052_GPIO1415_GPIO14TYPE		(1<<2)
#define DA9052_GPIO1415_GPIO14PIN		(3<<0)

/*POWER SEQUENCER REGISTER*/

/* SEQ control register for ID 0 and 1 */
#define DA9052_ID01_LDO1STEP			(15<<4)
#define DA9052_ID01_SYSPRE			(1<<2)
#define DA9052_ID01_DEFSUPPLY			(1<<1)
#define DA9052_ID01_nRESMODE			(1<<0)

/* SEQ control register for ID 2 and 3 */
#define DA9052_ID23_LDO3STEP			(15<<4)
#define DA9052_ID23_LDO2STEP			(15<<0)

/* SEQ control register for ID 4 and 5 */
#define DA9052_ID45_LDO5STEP			(15<<4)
#define DA9052_ID45_LDO4STEP			(15<<0)

/* SEQ control register for ID 6 and 7 */
#define DA9052_ID67_LDO7STEP			(15<<4)
#define DA9052_ID67_LDO6STEP			(15<<0)

/* SEQ control register for ID 8 and 9 */
#define DA9052_ID89_LDO9STEP			(15<<4)
#define DA9052_ID89_LDO8STEP			(15<<0)

/* SEQ control register for ID 10 and 11 */
#define DA9052_ID1011_PDDISSTEP			(15<<4)
#define DA9052_ID1011_LDO10STEP			(15<<0)

/* SEQ control register for ID 12 and 13 */
#define DA9052_ID1213_VMEMSWSTEP		(15<<4)
#define DA9052_ID1213_VPERISWSTEP		(15<<0)

/* SEQ control register for ID 14 and 15 */
#define DA9052_ID1415_BUCKPROSTEP		(15<<4)
#define DA9052_ID1415_BUCKCORESTEP		(15<<0)

/* SEQ control register for ID 16 and 17 */
#define DA9052_ID1617_BUCKPERISTEP		(15<<4)
#define DA9052_ID1617_BUCKMEMSTEP		(15<<0)

/* SEQ control register for ID 18 and 19 */
#define DA9052_ID1819_GPRISE2STEP		(15<<4)
#define DA9052_ID1819_GPRISE1STEP		(15<<0)

/* SEQ control register for ID 20 and 21 */
#define DA9052_ID2021_GPFALL2STEP		(15<<4)
#define DA9052_ID2021_GPFALL1STEP		(15<<0)

/* Power SEQ Status register */
#define DA9052_SEQSTATUS_SEQPOINTER		(15<<4)
#define DA9052_SEQSTATUS_WAITSTEP		(15<<0)

/* Power SEQ A register */
#define DA9052_SEQA_POWEREND			(15<<4)
#define DA9052_SEQA_SYSTEMEND			(15<<0)

/* Power SEQ B register */
#define DA9052_SEQB_PARTDOWN			(15<<4)
#define DA9052_SEQB_MAXCOUNT			(15<<0)

/* Power SEQ TIMER register */
#define DA9052_SEQTIMER_SEQDUMMY		(15<<4)
#define DA9052_SEQTIMER_SEQTIME			(15<<0)

/*POWER SUPPLY CONTROL REGISTER*/

/* BUCK REGISTER A */
#define DA9052_BUCKA_BPROILIM			(3<<6)
#define DA9052_BUCKA_BPROMODE			(3<<4)
#define DA9052_BUCKA_BCOREILIM			(3<<2)
#define DA9052_BUCKA_BCOREMODE			(3<<0)

/* BUCK REGISTER B */
#define DA9052_BUCKB_BERIILIM			(3<<6)
#define DA9052_BUCKB_BPERIMODE			(3<<4)
#define DA9052_BUCKB_BMEMILIM			(3<<2)
#define DA9052_BUCKB_BMEMMODE			(3<<0)

/* BUCKCORE REGISTER */
#define DA9052_BUCKCORE_BCORECONF		(1<<7)
#define DA9052_BUCKCORE_BCOREEN			(1<<6)
#define DA9052_BUCKCORE_VBCORE			(63<<0)

/* BUCKPRO REGISTER */
#define DA9052_BUCKPRO_BPROCONF			(1<<7)
#define DA9052_BUCKPRO_BPROEN			(1<<6)
#define DA9052_BUCKPRO_VBPRO			(63<<0)

/* BUCKMEM REGISTER */
#define DA9052_BUCKMEM_BMEMCONF			(1<<7)
#define DA9052_BUCKMEM_BMEMEN			(1<<6)
#define DA9052_BUCKMEM_VBMEM			(63<<0)

/* BUCKPERI REGISTER */
#define DA9052_BUCKPERI_BPERICONF		(1<<7)
#define DA9052_BUCKPERI_BPERIEN			(1<<6)
#define DA9052_BUCKPERI_VBPERI			(63<<0)

/* LDO1 REGISTER */
#define DA9052_LDO1_LDO1CONF			(1<<7)
#define DA9052_LDO1_LDO1EN			(1<<6)
#define DA9052_LDO1_VLDO1			(63<<0)

/* LDO2 REGISTER */
#define DA9052_LDO2_LDO2CONF			(1<<7)
#define DA9052_LDO2_LDO2EN			(1<<6)
#define DA9052_LDO2_VLDO2			(63<<0)

/* LDO3 REGISTER */
#define DA9052_LDO3_LDO3CONF			(1<<7)
#define DA9052_LDO3_LDO3EN			(1<<6)
#define DA9052_LDO3_VLDO3			(63<<0)

/* LDO4 REGISTER */
#define DA9052_LDO4_LDO4CONF			(1<<7)
#define DA9052_LDO4_LDO4EN			(1<<6)
#define DA9052_LDO4_VLDO4			(63<<0)

/* LDO5 REGISTER */
#define DA9052_LDO5_LDO5CONF			(1<<7)
#define DA9052_LDO5_LDO5EN			(1<<6)
#define DA9052_LDO5_VLDO5			(63<<0)

/* LDO6 REGISTER */
#define DA9052_LDO6_LDO6CONF			(1<<7)
#define DA9052_LDO6_LDO6EN			(1<<6)
#define DA9052_LDO6_VLDO6			(63<<0)

/* LDO7 REGISTER */
#define DA9052_LDO7_LDO7CONF			(1<<7)
#define DA9052_LDO7_LDO7EN			(1<<6)
#define DA9052_LDO7_VLDO7			(63<<0)

/* LDO8 REGISTER */
#define DA9052_LDO8_LDO8CONF			(1<<7)
#define DA9052_LDO8_LDO8EN			(1<<6)
#define DA9052_LDO8_VLDO8			(63<<0)

/* LDO9 REGISTER */
#define DA9052_LDO9_LDO9CONF			(1<<7)
#define DA9052_LDO9_LDO9EN			(1<<6)
#define DA9052_LDO9_VLDO9			(63<<0)

/* LDO10 REGISTER */
#define DA9052_LDO10_LDO10CONF			(1<<7)
#define DA9052_LDO10_LDO10EN			(1<<6)
#define DA9052_LDO10_VLDO10			(63<<0)

/* SUPPLY REGISTER */
#define DA9052_SUPPLY_VLOCK			(1<<7)
#define DA9052_SUPPLY_VMEMSWEN			(1<<6)
#define DA9052_SUPPLY_VPERISWEN			(1<<5)
#define DA9052_SUPPLY_VLDO3GO			(1<<4)
#define DA9052_SUPPLY_VLDO2GO			(1<<3)
#define DA9052_SUPPLY_VBMEMGO			(1<<2)
#define DA9052_SUPPLY_VBPROGO			(1<<1)
#define DA9052_SUPPLY_VBCOREGO			(1<<0)

/* PULLDOWN REGISTER */
#define DA9052_PULLDOWN_LDO5PDDIS		(1<<5)
#define DA9052_PULLDOWN_LDO2PDDIS		(1<<4)
#define DA9052_PULLDOWN_LDO1PDDIS		(1<<3)
#define DA9052_PULLDOWN_MEMPDDIS		(1<<2)
#define DA9052_PULLDOWN_PROPDDIS		(1<<1)
#define DA9052_PULLDOWN_COREPDDIS		(1<<0)

/* BAT CHARGER REGISTER */

/* CHARGER BUCK REGISTER */
#define DA9052_CHGBUCK_CHGTEMP			(1<<7)
#define DA9052_CHGBUCK_CHGUSBILIM		(1<<6)
#define DA9052_CHGBUCK_CHGBUCKLP		(1<<5)
#define DA9052_CHGBUCK_CHGBUCKEN		(1<<4)
#define DA9052_CHGBUCK_ISETBUCK			(15<<0)

/* WAIT COUNTER REGISTER */
#define DA9052_WAITCONT_WAITDIR			(1<<7)
#define DA9052_WAITCONT_RTCCLOCK		(1<<6)
#define DA9052_WAITCONT_WAITMODE		(1<<5)
#define DA9052_WAITCONT_EN32KOUT		(1<<4)
#define DA9052_WAITCONT_DELAYTIME		(15<<0)

/* ISET CONTROL REGISTER */
#define DA9052_ISET_ISETDCIN			(15<<4)
#define DA9052_ISET_ISETVBUS			(15<<0)

/* BATTERY CHARGER CONTROL REGISTER */
#define DA9052_BATCHG_ICHGPRE			(3<<6)
#define DA9052_BATCHG_ICHGBAT			(63<<0)

/* CHARGER COUNTER REGISTER */
#define DA9052_CHGCONT_VCHGBAT			(31<<3)
#define DA9052_CHGCONT_TCTR			(7<<0)

/* INPUT CONTROL REGISTER */
#define DA9052_INPUTCONT_TCTRMODE		(1<<7)
#define DA9052_INPUTCONT_ICHGLOW		(1<<5)
#define DA9052_INPUTCONT_VBUSSUSP		(1<<4)
#define DA9052_INPUTCONT_DCINSUSP		(1<<3)
#define DA9052_INPUTCONT_VCHGTHR		(7<<0)

/* CHARGING TIME REGISTER */
#define DA9052_CHGTIME_CHGTIME			(255<<0)

/* BACKUP BATTERY CONTROL REGISTER */
#define DA9052_BBATCONT_BCHARGERISET		(15<<4)
#define DA9052_BBATCONT_BCHARGERVSET		(15<<0)

/* LED REGISTERS */

/* LED BOOST REGISTER */
#define DA9052_BOOST_EBFAULT			(1<<7)
#define DA9052_BOOST_MBFAULT			(1<<6)
#define DA9052_BOOST_BOOSTFRQ			(1<<5)
#define DA9052_BOOST_BOOSTILIM			(1<<4)
#define DA9052_BOOST_LED3INEN			(1<<3)
#define DA9052_BOOST_LED2INEN			(1<<2)
#define DA9052_BOOST_LED1INEN			(1<<1)
#define DA9052_BOOST_BOOSTEN			(1<<0)

/* LED COUNT REGISTER */
#define DA9052_LEDCONT_LED3ICONT		(1<<6)
#define DA9052_LEDCONT_LED3RAMP			(1<<5)
#define DA9052_LEDCONT_LED3EN			(1<<4)
#define DA9052_LEDCONT_LED2RAMP			(1<<3)
#define DA9052_LEDCONT_LED2EN			(1<<2)
#define DA9052_LEDCONT_LED1RAMP			(1<<1)
#define DA9052_LEDCONT_LED1EN			(1<<0)

/* LEDMIN123  REGISTER */
#define DA9052_LEDMIN123_LEDMINCURRENT		(255<<0)

/* LED1CONF  REGISTER */
#define DA9052_LED1CONF_LED1CURRENT		(255<<0)

/* LED2CONF  REGISTER */
#define DA9052_LED2CONF_LED2CURRENT		(255<<0)

/* LED3CONF  REGISTER */
#define DA9052_LED3CONF_LED3CURRENT		(255<<0)

/* LED1 COUNT  REGISTER */
#define DA9052_LED1CONT_LED1DIM			(1<<7)
#define DA9052_LED1CONT_LED1PWM			(127<<0)

/* LED2 COUNT  REGISTER */
#define DA9052_LED2CONT_LED2DIM			(1<<7)
#define DA9052_LED2CONT_LED2PWM			(127<<0)

/* LED3 COUNT  REGISTER */
#define DA9052_LED3CONT_LED3DIM			(1<<7)
#define DA9052_LED3CONT_LED3PWM			(127<<0)

/* LED4 COUNT  REGISTER */
#define DA9052_LED4CONT_LED4DIM			(1<<7)
#define DA9052_LED4CONT_LED4PWM			(127<<0)

/* LED5 COUNT  REGISTER */
#define DA9052_LED5CONT_LED5DIM			(1<<7)
#define DA9052_LED5CONT_LED5PWM			(127<<0)

/* ADC REGISTERS */

/* ADC MAN registers */
#define DA9052_ADCMAN_MANCONV			(1<<4)
#define DA9052_ADCMAN_MUXSEL			(15<<0)

/* ADC COUNT regsisters */
#define DA9052_ADCCONT_COMP1V2EN		(1<<7)
#define DA9052_ADCCONT_ADCMODE			(1<<6)
#define DA9052_ADCCONT_TBATISRCEN		(1<<5)
#define DA9052_ADCCONT_AD4ISRCEN		(1<<4)
#define DA9052_ADCCONT_AUTOAD6EN		(1<<3)
#define DA9052_ADCCONT_AUTOAD5EN		(1<<2)
#define DA9052_ADCCONT_AUTOAD4EN		(1<<1)
#define DA9052_ADCCONT_AUTOVDDEN		(1<<0)

/* ADC 10 BIT MANUAL CONVERSION RESULT LOW register */
#define DA9052_ADCRESL_ADCRESLSB		(3<<0)

/* ADC 10 BIT MANUAL CONVERSION RESULT HIGH register */
#define DA9052_ADCRESH_ADCRESMSB		(255<<0)

/* VDD RES regsister*/
#define DA9052_VDDRES_VDDOUTRES			(255<<0)

/* VDD MON regsister*/
#define DA9052_VDDMON_VDDOUTMON			(255<<0)

/* ICHG_AV regsister*/
#define DA9052_ICHGAV_ICHGAV			(255<<0)

/* ICHG_THD regsister*/
#define DA9052_ICHGTHD_ICHGTHD			(255<<0)

/* ICHG_END regsister*/
#define DA9052_ICHGEND_ICHGEND			(255<<0)

/* TBAT_RES regsister*/
#define DA9052_TBATRES_TBATRES			(255<<0)

/* TBAT_HIGHP regsister*/
#define DA9052_TBATHIGHP_TBATHIGHP		(255<<0)

/* TBAT_HIGHN regsister*/
#define DA9052_TBATHIGHN_TBATHIGHN		(255<<0)

/* TBAT_LOW regsister*/
#define DA9052_TBATLOW_TBATLOW			(255<<0)

/* T_OFFSET regsister*/
#define DA9052_TOFFSET_TOFFSET			(255<<0)

/* ADCIN4_RES regsister*/
#define DA9052_ADCIN4RES_ADCIN4RES		(255<<0)

/* ADCIN4_HIGH regsister*/
#define DA9052_AUTO4HIGH_AUTO4HIGH		(255<<0)

/* ADCIN4_LOW regsister*/
#define DA9052_AUTO4LOW_AUTO4LOW		(255<<0)

/* ADCIN5_RES regsister*/
#define DA9052_ADCIN5RES_ADCIN5RES		(255<<0)

/* ADCIN5_HIGH regsister*/
#define DA9052_AUTO5HIGH_AUTOHIGH		(255<<0)

/* ADCIN5_LOW regsister*/
#define DA9052_AUTO5LOW_AUTO5LOW		(255<<0)

/* ADCIN6_RES regsister*/
#define DA9052_ADCIN6RES_ADCIN6RES		(255<<0)

/* ADCIN6_HIGH regsister*/
#define DA9052_AUTO6HIGH_AUTO6HIGH		(255<<0)

/* ADCIN6_LOW regsister*/
#define DA9052_AUTO6LOW_AUTO6LOW		(255<<0)

/* TJUNC_RES regsister*/
#define DA9052_TJUNCRES_TJUNCRES		(255<<0)

/* TSI REGISTER */

/* TSI Control Register A */
#define DA9052_TSICONTA_TSIDELAY		(3<<6)
#define DA9052_TSICONTA_TSISKIP			(7<<3)
#define DA9052_TSICONTA_TSIMODE			(1<<2)
#define DA9052_TSICONTA_PENDETEN		(1<<1)
#define DA9052_TSICONTA_AUTOTSIEN		(1<<0)

/* TSI Control Register B */
#define DA9052_TSICONTB_ADCREF			(1<<7)
#define DA9052_TSICONTB_TSIMAN			(1<<6)
#define DA9052_TSICONTB_TSIMUX			(3<<4)
#define DA9052_TSICONTB_TSISEL3			(1<<3)
#define DA9052_TSICONTB_TSISEL2			(1<<2)
#define DA9052_TSICONTB_TSISEL1			(1<<1)
#define DA9052_TSICONTB_TSISEL0			(1<<0)

/* TSI X Co-ordinate MSB Result register */
#define DA9052_TSIXMSB_TSIXM			(255<<0)

/* TSI Y Co-ordinate MSB Result register */
#define DA9052_TSIYMSB_TSIYM			(255<<0)

/* TSI Co-ordinate LSB Result register */
#define DA9052_TSILSB_PENDOWN			(1<<6)
#define DA9052_TSILSB_TSIZL			(3<<4)
#define DA9052_TSILSB_TSIYL			(3<<2)
#define DA9052_TSILSB_TSIXL			(3<<0)

/* TSI Z Measurement MSB Result register */
#define DA9052_TSIZMSB_TSIZM			(255<<0)

/* RTC REGISTER */

/* RTC TIMER SECONDS REGISTER */
#define DA9052_COUNTS_MONITOR			(1<<6)
#define DA9052_COUNTS_COUNTSEC			(63<<0)

/* RTC TIMER MINUTES REGISTER */
#define DA9052_COUNTMI_COUNTMIN			(63<<0)

/* RTC TIMER HOUR REGISTER */
#define DA9052_COUNTH_COUNTHOUR			(31<<0)

/* RTC TIMER DAYS REGISTER */
#define DA9052_COUNTD_COUNTDAY			(31<<0)

/* RTC TIMER MONTHS REGISTER */
#define DA9052_COUNTMO_COUNTMONTH		(15<<0)

/* RTC TIMER YEARS REGISTER */
#define DA9052_COUNTY_COUNTYEAR			(63<<0)

/* RTC ALARM MINUTES REGISTER */
#define DA9052_ALARMMI_TICKTYPE			(1<<7)
#define DA9052_ALARMMI_ALARMTYPE		(1<<6)
#define DA9052_ALARMMI_ALARMMIN			(63<<0)

/* RTC ALARM HOURS REGISTER */
#define DA9052_ALARMH_ALARMHOUR			(31<<0)

/* RTC ALARM DAYS REGISTER */
#define DA9052_ALARMD_ALARMDAY			(31<<0)

/* RTC ALARM MONTHS REGISTER */
#define DA9052_ALARMMO_ALARMMONTH		(15<<0)

/* RTC ALARM YEARS REGISTER */
#define DA9052_ALARMY_TICKON			(1<<7)
#define DA9052_ALARMY_ALARMON			(1<<6)
#define DA9052_ALARMY_ALARMYEAR			(63<<0)

/* RTC SECONDS REGISTER  A*/
#define DA9052_SECONDA_SECONDSA			(255<<0)

/* RTC SECONDS REGISTER  B*/
#define DA9052_SECONDB_SECONDSB			(255<<0)

/* RTC SECONDS REGISTER  C*/
#define DA9052_SECONDC_SECONDSC			(255<<0)

/* RTC SECONDS REGISTER  D*/
#define DA9052_SECONDD_SECONDSD			(255<<0)

/* OTP REGISTER */

/* CHIP IDENTIFICATION REGISTER */
#define DA9052_CHIPID_MRC			(15<<4)
#define DA9052_CHIPID_TRC			(15<<0)

/* CONFIGURATION IDENTIFICATION REGISTER */
#define DA9052_CONFIGID_CUSTOMERID		(31<<3)
#define DA9052_CONFIGID_CONFID			(7<<0)

/* OTP CONTROL REGISTER */
#define DA9052_OTPCONT_GPWRITEDIS		(1<<7)
#define DA9052_OTPCONT_OTPCONFLOCK		(1<<6)
#define DA9052_OTPCONT_OTPGPLOCK		(1<<5)
#define DA9052_OTPCONT_OTPCONFG			(1<<3)
#define DA9052_OTPCONT_OTPGP			(1<<2)
#define DA9052_OTPCONT_OTPRP			(1<<1)
#define DA9052_OTPCONT_OTPTRANSFER		(1<<0)

/* RTC OSCILLATOR TRIM REGISTER */
#define DA9052_OSCTRIM_TRIM32K			(255<<0)

/* GP ID REGISTER 0 */
#define DA9052_GPID0_GP0			(255<<0)

/* GP ID REGISTER 1 */
#define DA9052_GPID1_GP1			(255<<0)

/* GP ID REGISTER 2 */
#define DA9052_GPID2_GP2			(255<<0)

/* GP ID REGISTER 3 */
#define DA9052_GPID3_GP3			(255<<0)

/* GP ID REGISTER 4 */
#define DA9052_GPID4_GP4			(255<<0)

/* GP ID REGISTER 5 */
#define DA9052_GPID5_GP5			(255<<0)

/* GP ID REGISTER 6 */
#define DA9052_GPID6_GP6			(255<<0)

/* GP ID REGISTER 7 */
#define DA9052_GPID7_GP7			(255<<0)

/* GP ID REGISTER 8 */
#define DA9052_GPID8_GP8			(255<<0)

/* GP ID REGISTER 9 */
#define DA9052_GPID9_GP9			(255<<0)

#endif
/* __LINUX_MFD_DA9052_REG_H */
