/* -*- linux-c -*-
 *
 * arch/arm/mach-s3c2410/include/mach/regs-s3c2443-mem.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * S3C2443 memory register definitions
 *
 * Copyright (c) 2009 Digi International
 *
 * Author: Luis Galdos <luis.galdos@digi.com>
 *
 */

#ifndef __ASM_ARM_REGS_S3C2443_MEM
#define __ASM_ARM_REGS_S3C2443_MEM

#include <plat/map.h>
#include <mach/map.h>

#define S3C2443_MEMREG(x)               (S3C24XX_VA_MEMCTRL + (x))

/*
 * @XXX: Add the SSMC registers to the minimal IO mapping table of [1]
 * [1] arch/arm/plat-s3c24xx/cpu.c
 *
 * Luis Galdos
 */
#if 0
#define S3C2443_SSMCREG(x)          (S3C2443_VA_SSMC + (x))
#else
#define S3C2443_SSMCREG(x)          (x)
#endif

#define S3C2443_BANKCFG             S3C2443_MEMREG(0x0000)
#define S3C2443_BANKCON1            S3C2443_MEMREG(0x0004)
#define S3C2443_BANKCON2            S3C2443_MEMREG(0x0008)
#define S3C2443_BANKCON3            S3C2443_MEMREG(0x000C)
#define S3C2443_REFRESH             S3C2443_MEMREG(0x0010)
#define S3C2443_TIMEOUT             S3C2443_MEMREG(0x0014)

/* Bank Idle Cycle Control Registers 0-5 */
#define S3C2443_SSMC_SMBIDCYR0	    S3C2443_SSMCREG(0x0000)
#define S3C2443_SSMC_SMBIDCYR1	    S3C2443_SSMCREG(0x0020)
#define S3C2443_SSMC_SMBIDCYR2	    S3C2443_SSMCREG(0x0040)
#define S3C2443_SSMC_SMBIDCYR3	    S3C2443_SSMCREG(0x0060)
#define S3C2443_SSMC_SMBIDCYR4	    S3C2443_SSMCREG(0x0080)
#define S3C2443_SSMC_SMBIDCYR5	    S3C2443_SSMCREG(0x00A0)
#define S3C2443_SSMC_SMBIDCYR6	    S3C2443_SSMCREG(0x00C0)
#define S3C2443_SSMC_SMBIDCYR7	    S3C2443_SSMCREG(0x00E0)

/* Bank Read Wait State Contro, Registers 0-5 */
#define S3C2443_SSMC_SMBWSTRDR0	    S3C2443_SSMCREG(0x0004)
#define S3C2443_SSMC_SMBWSTRDR1	    S3C2443_SSMCREG(0x0024)
#define S3C2443_SSMC_SMBWSTRDR2	    S3C2443_SSMCREG(0x0044)
#define S3C2443_SSMC_SMBWSTRDR3	    S3C2443_SSMCREG(0x0064)
#define S3C2443_SSMC_SMBWSTRDR4	    S3C2443_SSMCREG(0x0084)
#define S3C2443_SSMC_SMBWSTRDR5	    S3C2443_SSMCREG(0x00A4)
#define S3C2443_SSMC_SMBWSTRDR6	    S3C2443_SSMCREG(0x00C4)
#define S3C2443_SSMC_SMBWSTRDR7	    S3C2443_SSMCREG(0x00E4)

/* Bank Write Wait State Control, Registers 0-5 */
#define S3C2443_SSMC_SMBWSTWRR0	    S3C2443_SSMCREG(0x0008)
#define S3C2443_SSMC_SMBWSTWRR1	    S3C2443_SSMCREG(0x0028)
#define S3C2443_SSMC_SMBWSTWRR2	    S3C2443_SSMCREG(0x0048)
#define S3C2443_SSMC_SMBWSTWRR3	    S3C2443_SSMCREG(0x0068)
#define S3C2443_SSMC_SMBWSTWRR4	    S3C2443_SSMCREG(0x0088)
#define S3C2443_SSMC_SMBWSTWRR5	    S3C2443_SSMCREG(0x00A8)
#define S3C2443_SSMC_SMBWSTWRR6	    S3C2443_SSMCREG(0x00C8)
#define S3C2443_SSMC_SMBWSTWRR7	    S3C2443_SSMCREG(0x00E8)

/* Bank OutPut enable Assertion Delay Control Registers 0-5 */
#define S3C2443_SSMC_SMBWSTOENR0    S3C2443_SSMCREG(0x000C)
#define S3C2443_SSMC_SMBWSTOENR1    S3C2443_SSMCREG(0x002C)
#define S3C2443_SSMC_SMBWSTOENR2    S3C2443_SSMCREG(0x004C)
#define S3C2443_SSMC_SMBWSTOENR3    S3C2443_SSMCREG(0x006C)
#define S3C2443_SSMC_SMBWSTOENR4    S3C2443_SSMCREG(0x008C)
#define S3C2443_SSMC_SMBWSTOENR5    S3C2443_SSMCREG(0x00AC)
#define S3C2443_SSMC_SMBWSTOENR6    S3C2443_SSMCREG(0x00CC)
#define S3C2443_SSMC_SMBWSTOENR7    S3C2443_SSMCREG(0x00EC)

/* Bank Write enable Assertion Delay Control Registers 0-5 */
#define S3C2443_SSMC_SMBWSTWENR0    S3C2443_SSMCREG(0x0010)
#define S3C2443_SSMC_SMBWSTWENR1    S3C2443_SSMCREG(0x0030)
#define S3C2443_SSMC_SMBWSTWENR2    S3C2443_SSMCREG(0x0050)
#define S3C2443_SSMC_SMBWSTWENR3    S3C2443_SSMCREG(0x0070)
#define S3C2443_SSMC_SMBWSTWENR4    S3C2443_SSMCREG(0x0090)
#define S3C2443_SSMC_SMBWSTWENR5    S3C2443_SSMCREG(0x00B0)
#define S3C2443_SSMC_SMBWSTWENR6    S3C2443_SSMCREG(0x00D0)
#define S3C2443_SSMC_SMBWSTWENR7    S3C2443_SSMCREG(0x00F0)

/* Bank Control Registers 0-5 */
#define S3C2443_SSMC_SMBCR0	    S3C2443_SSMCREG(0x0014)
#define S3C2443_SSMC_SMBCR1	    S3C2443_SSMCREG(0x0034)
#define S3C2443_SSMC_SMBCR2	    S3C2443_SSMCREG(0x0054)
#define S3C2443_SSMC_SMBCR3	    S3C2443_SSMCREG(0x0074)
#define S3C2443_SSMC_SMBCR4	    S3C2443_SSMCREG(0x0094)
#define S3C2443_SSMC_SMBCR5	    S3C2443_SSMCREG(0x00B4)
#define S3C2443_SSMC_SMBCR6	    S3C2443_SSMCREG(0x00D4)
#define S3C2443_SSMC_SMBCR7	    S3C2443_SSMCREG(0x00F4)

/* Bank Control bitfields */
#define S3C2443_SSMC_SMBC_AVWE		1 << 20
#define S3C2443_SSMC_SMBC_BLW_8		1 << 18
#define S3C2443_SSMC_SMBC_BLW_CONT	3 << 18
#define S3C2443_SSMC_SMBC_BMW		1 << 16
#define S3C2443_SSMC_SMBC_DROWE		1 << 15
#define S3C2443_SSMC_SMBC_WR		1 << 14
#define S3C2443_SSMC_SMBC_AVRE		1 << 12
#define S3C2443_SSMC_SMBC_BLR_8		1 << 10
#define S3C2443_SSMC_SMBC_BLR_16	2 << 10
#define S3C2443_SSMC_SMBC_BLR_CONT	3 << 10
#define S3C2443_SSMC_SMBC_SRD		1 << 9
#define S3C2443_SSMC_SMBC_BMR		1 << 8
#define S3C2443_SSMC_SMBC_DRCS		1 << 7
#define S3C2443_SSMC_SMBC_SMBLSPOL	1 << 6
#define S3C2443_SSMC_SMBC_MW_16		1 << 4
#define S3C2443_SSMC_SMBC_WP		1 << 3
#define S3C2443_SSMC_SMBC_WAIT		1 << 2
#define S3C2443_SSMC_SMBC_WPOL		1 << 1
#define S3C2443_SSMC_SMBC_RBLE		1 << 0

/* Bank Status Registers 0-5 */
#define S3C2443_SSMC_SMBSR0	    S3C2443_SSMCREG(0x0018)
#define S3C2443_SSMC_SMBSR1	    S3C2443_SSMCREG(0x0038)
#define S3C2443_SSMC_SMBSR2	    S3C2443_SSMCREG(0x0058)
#define S3C2443_SSMC_SMBSR3	    S3C2443_SSMCREG(0x0078)
#define S3C2443_SSMC_SMBSR4	    S3C2443_SSMCREG(0x0098)
#define S3C2443_SSMC_SMBSR5	    S3C2443_SSMCREG(0x00B8)
#define S3C2443_SSMC_SMBSR6	    S3C2443_SSMCREG(0x00D8)
#define S3C2443_SSMC_SMBSR7	    S3C2443_SSMCREG(0x00F8)

/* Bank Burst Read Wait delay Control Registers 0-5 */
#define S3C2443_SSMC_SMBWSTBRDR0    S3C2443_SSMCREG(0x001C)
#define S3C2443_SSMC_SMBWSTBRDR1    S3C2443_SSMCREG(0x003C)
#define S3C2443_SSMC_SMBWSTBRDR2    S3C2443_SSMCREG(0x005C)
#define S3C2443_SSMC_SMBWSTBRDR3    S3C2443_SSMCREG(0x007C)
#define S3C2443_SSMC_SMBWSTBRDR4    S3C2443_SSMCREG(0x009C)
#define S3C2443_SSMC_SMBWSTBRDR5    S3C2443_SSMCREG(0x00BC)
#define S3C2443_SSMC_SMBWSTBRDR6    S3C2443_SSMCREG(0x00DC)
#define S3C2443_SSMC_SMBWSTBRDR7    S3C2443_SSMCREG(0x00FC)

/* SROMC status register  */
#define S3C2443_SSMC_SSMCSR	    S3C2443_SSMCREG(0x0200)
/* SROMC control register  */
#define S3C2443_SSMC_SSMCCR	    S3C2443_SSMCREG(0x0204)

#endif /*  __ASM_ARM_REGS_S3C2443_MEM */
