/*
 * arch/arm/mach-ns9xxx/include/mach/irqs.h
 *
 * Copyright (C) 2006-2008 by Digi International Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 */
#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

/* Digi ns921x */
#define IRQ_NS9XXX_WATCHDOG	0
#define IRQ_NS9XXX_AHBBUSERR	1
#define IRQ_NS921X_EXTDMA	2
#define IRQ_NS921X_CPUWAKE	3
#define IRQ_NS9XXX_ETHRX	4
#define IRQ_NS9XXX_ETHTX	5
#define IRQ_NS9XXX_ETHPHY	6 /* reserved for ns9210 */
#define IRQ_NS921X_UARTA	7
#define IRQ_NS921X_UARTB	8
#define IRQ_NS921X_UARTC	9
#define IRQ_NS921X_UARTD	10
#define IRQ_NS921X_SPI		11
#define IRQ_NS921X_PIC0 	12
#define IRQ_NS921X_PIC1 	13
#define IRQ_NS9215_ADC		14
#define IRQ_NS9215_EPL		15
#define IRQ_NS921X_I2C		16
#define IRQ_NS9215_RTC		17
#define IRQ_NS921X_TIMER0	18
#define IRQ_NS921X_TIMER1	19
#define IRQ_NS921X_TIMER2	20
#define IRQ_NS921X_TIMER3	21
#define IRQ_NS921X_TIMER4	22
#define IRQ_NS921X_TIMER5	23
#define IRQ_NS921X_TIMER6	24
#define IRQ_NS921X_TIMER7	25
#define IRQ_NS921X_TIMER8	26
#define IRQ_NS921X_TIMER9	27
#define IRQ_NS9XXX_EXT0		28
#define IRQ_NS9XXX_EXT1		29
#define IRQ_NS9XXX_EXT2		30
#define IRQ_NS9XXX_EXT3		31

/* NetSilicon 9360 */
/* IRQ_NS9XXX_WATCHDOG		0 */
/* IRQ_NS9XXX_AHBBUSERR		1 */
#define IRQ_NS9360_BBUSAGG	2
/* irq 3 is reserved for NS9360 */
/* IRQ_NS9XXX_ETHRX		3 */
/* IRQ_NS9XXX_ETHTX		4 */
/* IRQ_NS9XXX_ETHPHY		5 */
#define IRQ_NS9360_LCD		7
#define IRQ_NS9360_SERBRX	8
#define IRQ_NS9360_SERBTX	9
#define IRQ_NS9360_SERARX	10
#define IRQ_NS9360_SERATX	11
#define IRQ_NS9360_SERCRX	12
#define IRQ_NS9360_SERCTX	13
#define IRQ_NS9360_I2C		14
#define IRQ_NS9360_BBUSDMA	15
#define IRQ_NS9360_TIMER0	16
#define IRQ_NS9360_TIMER1	17
#define IRQ_NS9360_TIMER2	18
#define IRQ_NS9360_TIMER3	19
#define IRQ_NS9360_TIMER4	20
#define IRQ_NS9360_TIMER5	21
#define IRQ_NS9360_TIMER6	22
#define IRQ_NS9360_TIMER7	23
#define IRQ_NS9360_RTC		24
#define IRQ_NS9360_USBHOST	25
#define IRQ_NS9360_USBDEVICE	26
#define IRQ_NS9360_IEEE1284	27
/* IRQ_NS9XXX_EXT0		28 */
/* IRQ_NS9XXX_EXT1		29 */
/* IRQ_NS9XXX_EXT2		30 */
/* IRQ_NS9XXX_EXT3		31 */

#define IRQ_NS9360_BBUS(irq)	(32 + irq)

#define IRQ_NS9360_BBUS_DMA		IRQ_NS9360_BBUS(0)
#define IRQ_NS9360_BBUS_SERBRX		IRQ_NS9360_BBUS(2)
#define IRQ_NS9360_BBUS_SERBTX		IRQ_NS9360_BBUS(3)
#define IRQ_NS9360_BBUS_SERARX		IRQ_NS9360_BBUS(4)
#define IRQ_NS9360_BBUS_SERATX		IRQ_NS9360_BBUS(5)
#define IRQ_NS9360_BBUS_SERCRX		IRQ_NS9360_BBUS(6)
#define IRQ_NS9360_BBUS_SERCTX		IRQ_NS9360_BBUS(7)
#define IRQ_NS9360_BBUS_SERDRX		IRQ_NS9360_BBUS(8)
#define IRQ_NS9360_BBUS_SERDTX		IRQ_NS9360_BBUS(9)
#define IRQ_NS9360_BBUS_I2C		IRQ_NS9360_BBUS(10)
#define IRQ_NS9360_BBUS_1284		IRQ_NS9360_BBUS(11)
#define IRQ_NS9360_BBUS_UTIL		IRQ_NS9360_BBUS(12)
#define IRQ_NS9360_BBUS_RTC		IRQ_NS9360_BBUS(13)
#define IRQ_NS9360_BBUS_USBHST		IRQ_NS9360_BBUS(14)
#define IRQ_NS9360_BBUS_USBDEV		IRQ_NS9360_BBUS(15)
#define IRQ_NS9360_BBUS_AHBDMA1		IRQ_NS9360_BBUS(24)
#define IRQ_NS9360_BBUS_AHBDMA2		IRQ_NS9360_BBUS(25)

#define IRQ_NS9360_BBUDMA(irq)	(58 + irq)

/*
 * these Interrupts are specific for the a9m9750dev board.
 * They are generated by an FPGA that interrupts the CPU on
 * IRQ_NS9360_EXT2
 */
#define FPGA_IRQ(irq)	(74 + irq)

#define IRQ_FPGA_UARTA		FPGA_IRQ(0)
#define IRQ_FPGA_UARTB		FPGA_IRQ(1)
#define IRQ_FPGA_UARTC		FPGA_IRQ(2)
#define IRQ_FPGA_UARTD		FPGA_IRQ(3)
#define IRQ_FPGA_TOUCH		FPGA_IRQ(4)
#define IRQ_FPGA_CF		FPGA_IRQ(5)
#define IRQ_FPGA_CAN0		FPGA_IRQ(6)
#define IRQ_FPGA_CAN1		FPGA_IRQ(7)

#define NR_IRQS	82

#endif /* __ASM_ARCH_IRQS_H */
