#!/bin/sh

path=/tmp/fwupd
script=${path}/upd_me909
fw=${path}/ME909_UPDATE_11.617.24.00.00.FWL

abort()
{
	echo "Error: $1"
	exit
}

test -x ${script} || abort "Update script not found"
test -r ${fw} || abort "Firmware image not found"

echo "Preparing cron job"

h=$(date +%H)
m=$(date +%M)

m=$((m+30))
if [ ${m} -ge 60 ]; then
	m=$((m-60))
	h=$((h+1))
fi

if [ ${h} -ge 24 ]; then
	h=$((h-24))
fi

date +"%Y-%m-%d %H:%M:%S"
echo "Reboot at ${h}:${m}"

ctab=$(mktemp /tmp/crontab-XXXXXX)
crontab -l > ${ctab}
echo "${m} ${h} * * * reboot" >> ${ctab}
crontab ${ctab}
rm -f ${ctab}


eval ${script} -b -r -v ${fw}
echo "Update started"

