#!/bin/bash

echo "alias dir='ls -la --color=auto'" > /root/.bashrc

/sbin/syslogd

##
## Set routing
##
host=$(hostname)
case "${host}" in
	router)
		ip route add 192.168.0.0/16 via 172.16.4.2
		ip route del default
		ip route add default via 172.16.4.10
		;;
	firewall)
		extif=$(ip -o addr | awk '/10\.10\.34\./{print $2}')
		intif=$(ip -o addr | awk '/172\.16\.4/{print $2}')
		ip route del default
		ip route add default via 10.10.34.1
		ip route add 172.16.0.0/12 via 172.16.4.1
		iptables -P FORWARD DROP
		iptables -A FORWARD -m state --state ESTABLISHED,RELATED -j ACCEPT
		iptables -A FORWARD -i ${intif} -o ${extif} -j ACCEPT
		iptables -A POSTROUTING -t nat -o ${extif} -j MASQUERADE
		;;
	br1|br2)
		ip addr flush eth0
		ip addr flush eth1
		brctl addbr br0
		brctl addif br0 eth0
		brctl addif br0 eth1
		ip link set dev br0 up
		;;
	gateway)
		## default setup is fine
		;;
esac

#echo "**** Running Busy Wait ****"
mkfifo /tmp/waitf
while true; do
	read a </tmp/waitf
done
