#!/bin/bash

if [ "$1" != "daemon" ]; then
	$0 daemon $@ &
	exit
fi
shift

fifo="/var/run/keepalived/fifo_vrrp"
logger -t NFYVR "Notify vrrp script: fifo = ${fifo}, id = $(id)"
if [ ! -p ${fifo} ]; then
	logger -t NFYVR "Error: fifo ${fifo} does not exist"
	exit
fi

while read line; do
	IFS=' ' read -r t n s p <<<"${line}"
	logger -t NFYVR "Event: type=${t}, name=${n}, state=${s}, prio=${p}"

	if [ "${t}" = "INSTANCE" -a "${n//\"/}" = "VI_ext" -a "${s}" = "FAULT" ]; then
		logger -t NFYVR "Kicking Bondix to kick clients"
		l=$(/opt/bondix/server/bxutil list | awk '
			/^ / { if ($NF > 0) print $1 " "}')
		for i in ${l}; do
			logger -t NFYVR "  Kicking tunnel $i"
			/opt/bondix/server/bxutil delete $i
		done
	fi
done <${fifo}

