#!/bin/bash

##
## Check current status.
##

verbose=0
if [ -r /var/run/keepalived/keepalived.state ]; then
	while read attr val; do
		[ "${attr}" = "State:" -a "${val}" = "MASTER" ] && verbose=1
	done < /var/run/keepalived/keepalived.state
fi

##
## Check whether bondix server is still running
##

pgrep bondixserver
if [ $? -ne 0 ]; then
	if [ ${verbose} -ne 0 ]; then
		logger -t VRRP "FAIL: Bondix server not running"
	fi
	exit 1
fi

##
## Check whether DefGW is still reachable
##
intnet=172.16.4
intgw=${intnet}.1
intif=$(ip -o addr | awk "/:vip/{next}/${intnet}\./{print \$2}")
if ! ping -qc 1 -w 1 ${intgw} -I ${intif} &>/dev/null; then
	logger -t VRRP "FAIL: Def GW int not reachable"
	exit 1
fi

## --

extnet=10.10.34
extgw=${extnet}.1
extif=$(ip -o addr | awk "/:vip/{next}/${extnet}\./{print \$2}")
if ! ping -qc 1 -w 1 ${extgw} -I ${extif} &>/dev/null; then
	logger -t VRRP "FAIL: Def GW ext not reachable"
	exit 1
fi

#pidfile=/var/run/bondixserver.pid
#if [ -e ${pidfile} ]; then
#	read pid <${pidfile}
#	## if ! kill -0 ${pid}: does not work due to missing privileges
#	## This script is run as user vrrp, bondixserver runs as root.
#	if [ ! -d /proc/${pid} ]; then
#		## Bondix server not running: fail
#		test "${s1}" = "MASTER" && logger -t VRRP "FAIL: Bondix not running with pid <${pid}>"
#		exit 1
#	fi
#fi

exit 0

