#pragma once

#include <string>
#include <vector>
#include <sstream>

class usl_tools {
	public:
	static void tokenize(const std::string& str,
                      std::vector<std::string>& tokens,
                      const std::string& delim);
	void skipwhite(std::string &str);
	void chop(std::string &str, int n = 1);
	void chopcrlf(std::string &str);

	template <typename T>
	static T strton(const std::string &s,
		       std::ios_base &base(std::ios_base &) = std::dec,
		       T errval = (T)0)
	{
		std::stringstream ss(s);
		T result(errval);
		ss >> base >> result;
		return result;
	}

	template <typename T>
	static std::string ntostr(const T &val,
		       std::ios_base &base(std::ios_base &) = std::dec)
	{
		std::stringstream ss;
		ss << base << val;
		return ss.str();
	}
};

