#include <iostream>
#include <list>
#include <map>
#include <climits>

#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <syslog.h>
#include <errno.h>
#include <sys/select.h>
#include <sys/stat.h>
#include <sys/time.h>

#define USL_TICKS	4

class usl_timer {
	/***
	 * Unit Tests
	 ***/
#ifdef UNITTEST
	friend class unittest;
#endif

	/***********************************************************
	 * Client Timer handling
	 ***********************************************************/
	private:
	struct timer {
		typedef unsigned int uint;
		uint id;
		bool running, deleting;
		uint interval;
		void (*callback)(void *arg);
		void (*callback2)(void *arg, void *context);
		void *arg, *context;
		timer(uint num, uint i, void (*callb)(void *), void *a) :
			id(num), running(true), deleting(false),
			interval(i), callback(callb), callback2(NULL),
			arg(a), context(NULL) {}
		timer(uint num, uint i, void (*callb)(void *, void *), void *a,
								void *ctxt) :
			id(num), running(true), deleting(false),
			interval(i), callback(NULL), callback2(callb),
			arg(a), context(ctxt) {}
		bool match(uint i) { return id == i; }
		bool match(void (*cb)(void *), const void *a) {
			return callback == cb && arg == a;
		}
		bool match(void (*cb)(void *, void *), const void *a,
			       const void *c) {
			return callback2 == cb && arg == a && context == c;
		}
		void del(uint i) { if ( id == i ) deleting = true; }
		void stop(uint i) { if ( id == i ) running = false; }
	};

	typedef std::multimap<unsigned int, struct timer> tmap;

	tmap timer_list_;
	volatile unsigned int tick_count_;
	unsigned int nextid_;

	public:

	/* Client Timer handling */
	int create_timer(int exp, struct timer &t);
	int create_timer(int exp, int ival, void (*cb)(void *), void *arg);
	int create_timer(int exp, int ival, void (*cb)(void *, void *),
				void *arg, void *context);

	void delete_timer(unsigned int id);
	void delete_timer(void (*cb)(void *), void *arg);
	void delete_timer(void (*cb)(void *, void *), void *arg, void *context);

	void clear_timer();
	void stop_timer(unsigned int id);

	int get_numtimer();
	unsigned int find_timer(void (*cb)(void *), void *arg);
	unsigned int find_timer(void (*cb)(void *, void *),
				void *arg, void *context);

	protected:
	usl_timer();
	usl_timer(usl_timer &);
	usl_timer &operator=(usl_timer &);
	~usl_timer();

	void tick();
	/* Internal timer tick handler */
	void timer_tick_handler(int fd);
};

template<class T, void (T::*func)(void *)>
void USLT(void *arg, void *ctxt)
{
	(static_cast<T*>(ctxt)->*func)(arg);
}

#define USLT(class, func) USLT<class, &class::func>

