#pragma once

#include <vector>

#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>

#include <sys/stat.h>
#include <sys/time.h>

#include "destroyer.h"


typedef void (*usl_pid_done_fn_t)(void *arg, pid_t pid, int sig, int ret);


/*
 * We maintain a list of child process pids and functions to call when
 * they exit.
 */
struct usl_pid_child {
	pid_t			pid;
	usl_pid_done_fn_t	callback;
	void			*arg;
};


class usl_pid {
	/***********************************************************
	 * PID handling
	 ***********************************************************/

	private:
	/***
	 * Singleton
	 ***/
	usl_pid();
	usl_pid(usl_pid &);
	usl_pid &operator=(usl_pid &);
	~usl_pid();
	friend class destroyer<usl_pid>;
	/***
	 * Singleton Variables
	 ***/
	static usl_pid *inst_;
	static destroyer<usl_pid> d_;
	/***
	 * Data
	 ***/
	std::vector<usl_pid_child> usl_child_list_;


	protected:
	/***
	 * Methods
	 ***/
	friend class usl_daemon;
	/* Call waitpid to check if any child has terminated */
	int reap_children(int waitfor);


	public:
	/***
	 * Singleton
	 ***/
	static usl_pid *instance();
	/***
	 * Methods
	 ***/
	int record_child(int pid, usl_pid_done_fn_t callback, void *arg);
	int remove_callback(int pid);
	/***
	 * Static Methods
	 ***/
	static pid_t safe_fork(void);
	static void daemonize();
};

template<class T, void (T::*func)(int, int, int)>
void USLP(void *arg, pid_t pid, int sig, int ret)
{
	(static_cast<T*>(arg)->*func)(pid, sig, ret);
}
#define USLP(class, func) USLP<class, &class::func>

