#pragma once

#include <sys/ioctl.h>

#include <string>

typedef enum {
	IRQ_HIGH,
	IRQ_LOW,
	IRQ_RISING,
	IRQ_FALLING,
	IRQ_BOTH,
	IRQ_RISING_LATENCY,
	IRQ_FALLING_LATENCY
} ext_irq_type_t;

/* ioctl magic numbers */
#define GPIO_IOCTL_BASE		'G'

/* inputs */
#define GPIO_CONFIG_AS_INP	_IO  (GPIO_IOCTL_BASE, 0)
#define GPIO_READ_PIN_VAL	_IOR (GPIO_IOCTL_BASE, 1, int)

/* outputs */
#define GPIO_CONFIG_AS_OUT	_IO  (GPIO_IOCTL_BASE, 2)
#define GPIO_WRITE_PIN_VAL	_IOW (GPIO_IOCTL_BASE, 3, int)

/* irqs */
#define GPIO_CONFIG_AS_IRQ	_IOR (GPIO_IOCTL_BASE, 4, ext_irq_type_t)

/* misc operations */
#define GPIO_CONFIG_INV_PIN	_IOR (GPIO_IOCTL_BASE, 5, int)

#define GPIO_IOCTL_MAXNR	5

class usl_gpio {
	public:
	usl_gpio(const std::string &port);
	~usl_gpio();

	int read();
	int readonly();
	int write(int val);
	int asirq(ext_irq_type_t type, int delay,
		void (*callback)(void *, void *) = nullptr,
		void *arg = nullptr, void *ctxt = nullptr);
	void unregirq(void);
	void interrupt(int fd, void *arg);

	private:
	std::string port_;
	int fd_;

	void (*callback_)(void *, void *);
	void *arg_;
	void *ctxt_;
	int delay_;
	int timer_;
};

template<class T, void (T::*func)(void *)>
void USLG(void *arg, void *ctxt)
{
	(static_cast<T*>(ctxt)->*func)(arg);
}

#define USLG(class, func) USLG<class, &class::func>
