#include <iostream>
#include <list>
#include <map>
#include <climits>

#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <syslog.h>
#include <errno.h>
#include <sys/select.h>
#include <sys/stat.h>
#include <sys/time.h>

class usl_fd {
	/***
	 * Unit Tests
	 ***/
#ifdef UNITTEST
	friend class unittest;
#endif

	/***********************************************************
	 * File descriptor handling
	 ***********************************************************/

	private:

	/***
	 * Data
	 ***/
	struct fd_entry {
		int fd;
		void (*callback)(int fd, void *arg);
		void (*callback2)(int fd, void *arg, void *context);
		void *arg, *context;
		fd_entry(int f, void (*cb)(int, void *), void *a) :
			fd(f), callback(cb), callback2(NULL), arg(a),
			context(NULL) {}
		fd_entry(int f, void (*cb)(int, void *, void *), void *a,
								void *ctxt) :
			fd(f), callback(NULL), callback2(cb), arg(a),
			context(ctxt) {}
	};

	// fd_list_: all fds that must be observed
	std::map<int, struct fd_entry> fd_list_;

	// active_list_: all fds that have data ready to be read
	std::list<struct fd_entry> active_list_;
	fd_set rfd_;
	int max_fd_;

	protected:
	int tick_pipe_[2];

	/***
	 * Methods
	 ***/

	int insert_fd(struct fd_entry &e);

	public:
	/* File descriptor handling */
	int add_fd(int fd, void (*callb)(int, void *), void *arg);
	int add_fd(int fd, void (*callb)(int, void *, void *), void *arg,
					void *context);
	bool find_fd(int fd);
	void remove_fd(int fd);
	void clear_fd();

	static size_t fd_read(int fd, void *buf, size_t count);

	protected:
	usl_fd();
	usl_fd(usl_fd &);
	usl_fd &operator=(usl_fd &);
	~usl_fd();

	void update_poll_set();
	void poll();
};

template <class T, void (T::*func)(int, void *)>
void USLF(int fd, void *arg, void *ctxt)
{
	(static_cast<T*>(ctxt)->*func)(fd, arg);
}

#define USLF(class, func) USLF<class, &class::func>

