#include <iostream>
#include <list>
#include <map>
#include <climits>

#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <syslog.h>
#include <errno.h>
#include <sys/select.h>
#include <sys/stat.h>
#include <sys/time.h>

#include "destroyer.h"
#include "usl_fd.h"
#include "usl_timer.h"
#include "usl_pid.h"

class usl_daemon : public usl_fd, public usl_timer {
	/***
	 * Singleton
	 ***/
 	public:
	static usl_daemon *instance();

	private:
	static usl_daemon *inst_;
	static destroyer<usl_daemon> d_;

	usl_daemon();
	usl_daemon(usl_daemon &);
	usl_daemon &operator=(usl_daemon &);
	~usl_daemon();
	friend class destroyer<usl_daemon>;

	/***
	 * Unit Tests
	 ***/
#ifdef UNITTEST
	friend class unittest;
#endif

	/***
	 * Private data
	 ***/

	private:

	/* Internal timer tick handling */
	volatile bool tick_pending_;

	/* Signal handling */
	volatile bool sighup_, sigterm_, sigchld_;

	/* Start timer. Must not be done in constructor, since
	 * constructor is called before daemonizing, and child process
	 * does not inherit timers from parent. */
	void start_timer();
	void stop_timer();

	friend void sigalarm(int sig);
	friend void sigterm(int sig);
	friend void sigchld(int sig);

	/*
	 * Public methods
	 */

	public:

	/* Internal timer tick handler */
	void tick_handler(int fd, void *arg);

	/* Main event loop.
	 * Returns only on SIGHUP and additionally on SIGTERM
	 * if ret_on_term is set.
	 * Returns the signal that caused the leaving of the event loop.
	 */
	int eventloop(bool ret_on_term = false);

	/*
	 * Internal helper methods
	 */
};

/* Shortcut for notation */
usl_daemon *usl();

