#pragma once
#include <string>
#include <vector>
#include <map>
#include <functional>

class usl_admin;

class admin_cmd {
	public:
	admin_cmd() : func_(nullptr), args_(""), info_("") { }
	admin_cmd(std::function<void(void*)> f, const std::string &a,
			const std::string &i) :
		func_(f), args_(a), info_(i) { }
	admin_cmd(const admin_cmd &a) :
		func_(a.func_), args_(a.args_), info_(a.info_) { }
	void call(void *arg) { if ( func_ ) func_(arg); }
	const std::string &args() const { return args_; }
	const std::string &info() const { return info_; }

	private:
	std::function<void(void*)> func_;
	std::string args_;
	std::string info_;
};

struct admin_info {
	int fd;
	std::string cmd;
	std::vector<std::string> args;
};

class usl_admin {
	public:
	usl_admin();
	~usl_admin();

	int setup(const std::string &socket);

	void register_cmd(std::function<void(void*)> func,
			const std::string &name, const std::string &arglist,
			const std::string &text);

	void do_help(void *arg);

	private:
	void close();

	void callcmd(int fd, void *arg);
	void uaccept(int fd, void *arg);
	void closesock(void *arg);

	void do_exec(int fd, const std::string &cmd, void *arg);

	private:
	int sock_;
	std::string sockname_;
	std::map<std::string, admin_cmd> cmds_;
	std::map<int, int> timers_;
};

