#ifndef __DESTROYER_H
#define __DESTROYER_H

template <class T>
class destroyer {
	public:
	destroyer(T *s = 0);
	~destroyer();

	void set(T *s);

	private:
	// prevent copying
	destroyer(const destroyer<T> &);
	destroyer<T> &operator=(const destroyer<T> &);

	T *_s;
};

template <class T>
destroyer<T>::destroyer(T *s)
{
	_s = s;
}

template <class T>
destroyer<T>::~destroyer()
{
	delete _s;
}

template <class T>
void destroyer<T>::set(T *s)
{
	_s = s;
}

#endif // defined __DESTROYER_H

