#ifndef __SERIAL_IFACE_H
#define __SERIAL_IFACE_H

/***
 * C++ interface
 ***/
#ifdef __cplusplus

#include <string>

class Iserial {
	protected:

	Iserial();
	Iserial(Iserial &);
	Iserial &operator=(Iserial &);

	public:
	Iserial(const std::string &device);
	virtual ~Iserial();

	static Iserial *create(const std::string &dev);
	static void remove(Iserial *ptr);

	virtual int get_nvgpo() = 0;
	virtual int get_nvgpo_eeprom() = 0;
	virtual int get_analog(const int x) = 0;
	virtual int get_wdog() = 0;
	virtual int get_wdog_time() = 0;
	virtual bool get_poe(const int idx) = 0;
	virtual bool get_gps() = 0;
	virtual std::string get_output(void) = 0;
	virtual bool get_5v() = 0;
	virtual bool get_console() = 0;
	virtual int get_wakeup() = 0;
	virtual int get_waketype() = 0;
	virtual int get_csd() = 0;
	virtual std::string get_picvers() = 0;

	virtual int feed(const bool speed = false) = 0;

	virtual void save_nvgpo() = 0;
	virtual void restore_nvgpo_eeprom() = 0;

	virtual void set_nvgpo(const int val) = 0;
	virtual void set_nvgpo_eeprom(const int val) = 0;
	virtual void set_wdog(const int val) = 0;
	virtual void set_output(const std::string &vals) = 0;
	virtual void set_poe(const int idx, const bool val) = 0;
	virtual void set_gps(const bool val) = 0;
	virtual void set_5v(const bool val) = 0;
	virtual void set_console(const bool val) = 0;
	virtual void set_waketimer(const int val) = 0;
	virtual void set_waketype(const int val) = 0;
	virtual void set_csd(const int val) = 0;
};
#endif // defined __cplusplus

/***
 * C interface
 ***/

#ifdef __cplusplus
extern "C" {
#endif
void serial_libopen(char *dev);
void serial_libclose(void);

int serial_get_nvgpo(void);
int serial_get_analog(int x);
int serial_get_wdog(void);
int serial_get_wdog_time(void);
int serial_get_poe(int x);
int serial_get_gps(void);
const char* serial_get_output(int idx);
int serial_get_5v(void);
int serial_get_console(void);
char *serial_get_picvers(void);

int serial_feed(int speed);
void serial_save_nvgpo(void);

void serial_set_nvgpo(int val);
void serial_set_wdog(int val);
void serial_set_output(const char *vals);
void serial_set_poe(int idx, int val);
void serial_set_gps(int val);
void serial_set_5v(int val);
void serial_set_console(int val);
#ifdef __cplusplus
}
#endif

#endif // defined __SERIAL_IFACE_H

