#ifndef __SERIAL_H
#define __SERIAL_H

#include <stdint.h>

#include <string>

#include "serial_iface.h"

class serial : public Iserial {
	private:
	enum {
		BIT_POE1 = (1 << 0),
		BIT_POE3 = (1 << 1),
		BIT_GPS = (1 << 2),
		BIT_5V = (1 << 3),
		BIT_CONSOLE = (1 << 4),
		BIT_OUTPUT_2_EN = (1 << 9),
		BIT_OUTPUT_3_EN = (1 << 10),
		BIT_OUTPUT_4_EN = (1 << 11),
		BIT_OUTPUT_2_CTRL = (1 << 13),
		BIT_OUTPUT_3_CTRL = (1 << 14),
		BIT_OUTPUT_4_CTRL = (1 << 15),
	};

	enum {
		CMD_NONE,
		CMD_WDOG_FEED = 0x02,
		CMD_PICVERS_READ = 0x03,
		CMD_WDOG_READ = 0x10,
		CMD_WDOG_WRITE = 0x11,
		CMD_WDOG_TIME = 0x12,
		CMD_CSD_READ = 0x20,
		CMD_CSD_WRITE = 0x21,
		CMD_GPIO_READ = 0x31,
		CMD_GPIO_WRITE = 0x32,
		CMD_GPIO_SAVE = 0x33,
		CMD_GPIO_EEPROM_RESTORE = 0x34,
		CMD_GPIO_EEPROM_READ = 0x35,
		CMD_GPIO_EEPROM_WRITE = 0x36,
		CMD_ANALOG_READ = 0x40,
		CMD_WAKEUP_READ = 0xa0,
		CMD_WAKEUP_WRITE = 0xa1,
		CMD_WAKETYPE_READ = 0xb0,
		CMD_WAKETYPE_WRITE = 0xb1,
	};

	protected:
	char _buf[8];
	std::string _device;

	serial();
	serial(serial &);
	serial &operator=(serial &);

	void send(const char *b, const int len);
	void receive(char *b, const int len, const int len2);
	uint8_t crc(const char* buf, const int len);
	void frame(char *msg, const char* buf, const uint8_t bufLen);
	void deframe(char *buf, const char* msg, const uint8_t msgLen);
	void modify_nvgpo(const int mask, const bool val);

	public:
	serial(const std::string &device);
	~serial();

	int get_nvgpo() override;
	int get_nvgpo_eeprom() override;
	int get_analog(const int x) override;
	int get_wdog() override;
	int get_wdog_time() override;
	bool get_poe(const int idx) override;
	bool get_gps() override;
	std::string get_output(void) override;
	bool get_5v() override;
	bool get_console() override;
	int get_wakeup() override;
	int get_waketype() override;
	int get_csd() override;
	std::string get_picvers() override;

	int feed(const bool speed = false) override;

	void save_nvgpo() override;
	void restore_nvgpo_eeprom() override;

	void set_nvgpo(const int val) override;
	void set_nvgpo_eeprom(const int val) override;
	void set_wdog(const int val) override;
	void set_poe(const int idx, const bool val) override;
	void set_gps(const bool val) override;
	void set_output(const std::string &vals) override;
	void set_5v(const bool val) override;
	void set_console(const bool val) override;
	void set_waketimer(const int val) override;
	void set_waketype(const int val) override;
	void set_csd(const int val) override;
};

#endif // defined __SERIAL_H

