#pragma once

#include <string>
#include <vector>
#include <sstream>

void tokenize(const std::string& str,
                      std::vector<std::string>& tokens,
                      const std::string& delim);

template <typename T>
T strton(const std::string &s, std::ios_base &base(std::ios_base &) = std::dec)
{
	std::stringstream ss(s);
	T result(0);
	ss >> base >> result;
	return result;
}

template <typename T>
std::string ntostr(const T &val, std::ios_base &base(std::ios_base &) = std::dec)
{
	std::stringstream ss;
	ss << base << val;
	return ss.str();
}

