/*
 * Libconfig2 - C bindings
 *
 * C interface compatible with libconfig v1 (written in C)
 *
 * Copyright (c) 2014 AnyWeb AG    www.anyweb.ch
 */

// Pointer is not used anymore, here for backwars compatibility
typedef void *lc_conf_file_p;

#ifdef __cplusplus
extern "C" {
#endif

lc_conf_file_p lc_open_config(const char *const path);

void lc_close_config(lc_conf_file_p handle);

int lc_parse_section(lc_conf_file_p handle, char *section,
			int (*parse_line)(char *section, char *attrib,
					char *value, void *arg),
			void *arg);

char *lc_get_directive(lc_conf_file_p handle, char *section,
				char *attrib, void *arg);

#ifdef __cplusplus
}
#endif

