/*
 * Libconfig2
 *
 * Config File Parsing Library
 * Version 2, C++
 *
 * Copyright (c) 2014 AnyWeb AG    www.anyweb.ch
 * 
 */

#include <string>
#include <map>
#include <fstream>

class libconfig {
	private:

	// Typing shortcuts
	typedef const std::string CS;
	typedef std::string S;

	// Full name of config file
	S cfgfile_;
	std::ifstream *ifs_;

	// Variable delimiting patterns and lengths
	S pat1_, pat2_;
	size_t np1_, np2_;

	// List of variables
	std::map<S, S> vars_;

	// Helper variables for get_attribute
	S attr_, value_;
	friend int mystrcmp(CS &section, CS &attrib, CS &value, void *arg);

	public:
	libconfig();
	libconfig(CS &file);
	~libconfig();

	private:
	// disallow copy constructor and assignment
	libconfig(libconfig &);
	libconfig &operator=(libconfig &);

	// Config variable handling
	void read_vars();
	void insert_cmds(S &line);
	void insert_keys(S &line);

	// external commands
	S call_cmd(CS &cmd);

	// Open config file, called from constructors
	void open();

	// Skip leading and trailing white space
	void skipwhite(S &s);

	public:
	bool isopen();

	// Setter and Getter functions
	void setstart(CS &pat);
	void setend(CS &pat);

	CS &getstart();
	CS &getend();

	void add_key(CS &attrib, CS &value);
	// Parse section of config file.
	// callback function is called for every attribute-value pair
	// present in this section
	int parse_section(CS &section,
		int (*callback)(CS &sect, CS &attrib, CS &value, void *arg),
		void *arg);

	// Get a single attribute from a section.
	// Returns value of attribute.
	CS get_attribute(CS &section, CS &attribute, void *arg);
};



