/*
 * Convert UBX message names to numbers
 *
 * Copyright (c) 2018 AnyWeb AG    www.anyweb.ch
 */
#include <string>
#include <map>

/*
 * UBX definitions
 */
class dti_ubx {
	private:
	std::map<std::string, int> classes_;
	//<class, <id, num> >
	std::map<std::string, std::map<std::string, int> > ids_;

	// Singleton
	static dti_ubx *inst_;
	dti_ubx();
	dti_ubx(dti_ubx &);
	dti_ubx &operator=(dti_ubx &);
	~dti_ubx();

	public:
	void add_class(const std::string &cl, const std::string &id);
	void add_id(const std::string &c1, const std::string &id,
			const std::string &val);
	std::string get_class(const std::string &cl);
	std::string get_id(const std::string &cl, const std::string &id);

	bool is_ubx(const std::string &inp, const std::string &cl = "",
			const std::string &id = "");

	void read_file(const std::string &file);

	std::string ubx_to_str(const std::string &ubx);

	static dti_ubx *instance();
};

// shortcut for notation
dti_ubx *dubx();

