/*
 * Single rule for GPXXX-Filter
 *
 * Copyright (c) 2018 AnyWeb AG    www.anyweb.ch
 */
#pragma once
#include <string>
#include <utility>

/*
 * One single filter rule
 */
class dti_rule {
	private:
	// <pattern, <time, dist> >
	typedef std::pair<int, int> type_;

	std::pair<std::string, type_ > rule_;
	std::pair<int, int> lastpos_;

	struct timeval last_;
	int last_d_, dist_base_;
	int debug_;

	int cid_;

	private:
	int filter_time();
	int filter_dist();

	public:
	dti_rule() {};
	dti_rule(const std::string &name, int time, int dist = 0);
	dti_rule(std::string &name, std::string &time, std::string &dist);

	int modify(const std::string &pat, int time, int dist);
	int modify(const std::string &pat, const std::string &time,
			const std::string &dist);

	void reset();

	// Debugging
	void dump();
	void debug(int deb);

	std::string getrule();

	// Filtering
	void time_dist_reset();
	int filter(const std::string &inp);
	int filter_ubx(const std::string &inp);
};

