/*
 * List of rules for GPXXX-Filter
 *
 * Copyright (c) 2018 AnyWeb AG    www.anyweb.ch
 */
#pragma once
#include <string>
#include <map>
#include <vector>

#include "dti_rule.h"

/*
 * List of filter rules
 */
class dti_flist {
	private:
	// <chain name, profile nr>
	typedef std::pair<std::string, int> key_;
	typedef std::vector<class dti_rule> type_;

	// All rules, indexed by chain name and profile number
	std::map<key_, type_> rules_;

	// Currently active profile for every rule name
	std::map<std::string, int> profile_;

	int debug_;

	public:
	dti_flist();

	// Setup functions
	// return value: >0 if any rule has a distance interval set.
	int add_rule(const std::string &id, int prof, const std::string &rule);
	int add_filter(const std::string &str);
	void modify(const std::string &name, const std::string &pat,
			int time, int dist, int prof = 0);
	void reset(const std::string &name, const std::string &prof);
	void clear();

	// Filtering
	int filter(const std::string &inp, const std::string &id);

	// Debugging
	void dump(int prof = -1);
	void debug(int deb);

	std::string getrules(const std::string &chain = "", int prof = -1);

	// Profile management
	int get_profile(const std::string &id);
	std::string get_profiles();
	void set_profile(const std::string &id, int prof);
};

