/*
 * C interface to CPP filter code for GPXXX-Filter
 *
 * Copyright (c) 2018 AnyWeb AG    www.anyweb.ch
 */
#ifdef __cplusplus
extern "C" {
#endif
	int  dti_config(char *string);
	int  dti_filter(const char *msg, int len, const char *id);
	void dti_modify(const char *name, const char *pat, int time, int dist);
	void dti_dump();
	void dti_debug(int dbg);
	void dti_profile(const char *string, int prof);
	int  dti_getprofile(const char *string);
	char *dti_getprofiles(void);
	char *dti_getrules(const char *chain, int prof);
	void dti_reset(const char *name, const char *prof);
	void dti_odoset(unsigned int dist, unsigned int total);
	void dti_clear(void);
#ifdef __cplusplus
}
#endif

