#pragma once

#include <string>
#include <vector>
#include <sstream>

#define TIMEDIFF(a,b) (((b).tv_sec  - (a).tv_sec ) * 1000000 + \
			(b).tv_usec - (a).tv_usec)
void tokenize(const std::string& str,
		std::vector<std::string>& tokens,
		const std::string& delim);

void skipwhite(std::string &str);
void chop(std::string &str, int n = 1);
void chopcrlf(std::string &str);

template <typename T>
T strton(const std::string &s, std::ios_base &base(std::ios_base &) = std::dec)
{
	std::stringstream ss(s);
	T result(0);
	ss >> base >> result;
	return result;
}

template <typename T>
std::string ntostr(const T &val)
{
	std::stringstream ss;
	ss << val;
	return ss.str();
}

template <typename T>
T strton2(const std::string &s)
{
	if ( s[0] == '0' && tolower(s[1]) == 'x' )
		return strton<T>(s, std::hex);
	return strton<T>(s);
}

int strncasecmpwld(const std::string &s1, const std::string &s2, size_t n,
			int debug = 0);
int strncmpwld(const std::string &s1, const std::string &s2, size_t n);
std::string mytolower(const std::string &in);

std::string hexdump(const std::string &in);

