#!/bin/sh

logfile=/var/log/anygateway.log
logfile2=/var/log/anygateway-shell.log
count=0
running=1

terminate()
{
	echo "$(date) Got SIGTERM, shutting down pid ${pid} +++" >> ${logfile2}
	running=0
	kill ${pid}
}

trap 'terminate' TERM

while true; do
	echo "$(date) Starting AnyGateway ***" >>${logfile2}
	begin=$(date +%s)
	## Run in background to be able to catch signals.
	## When the container is terminated (docker stop ...), this
	## script will receive SIGTERM.
	## If anygateway is run in foreground, the shell will not handle
	## the signal, and the container will eventually be shut with KILL.
	/opt/anygateway/bin/anygateway >${logfile} 2>&1 &
	pid=$!
	wait ${pid}
	ret=$?

	## If ${running} is 0, the signal handler was invoked.
	## Give the process time to shut down properly.
	if [ ${running} -eq 0 ]; then
		trap - TERM
		echo "$(date) Waiting for process to terminate" >>${logfile2}
		wait ${pid}
		ret=$?
	fi

	end=$(date +%s)
	t=$((end-begin))
	echo "$(date) AnyGateway terminated: retval = ${ret}, run time ${t}s" \
		>>${logfile2}

	test ${running} -eq 1 || break

	## Check runtime. If the container terminated more than 10 times
	## with runtimes below 10s, something is wrong, so we stop trying.
	if [ ${t} -lt 10 ]; then
		count=$((count+1))
		if [ ${count} -gt 10 ]; then
			echo "$(date) Abort, safety limit reached" >>${logfile2}
			break
		fi
	else
		count=0
	fi

	## Prevent restart storm in case of immediate termination
	sleep 2
done

